//$Id: property.cc,v 1.16 2003/06/30 14:07:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "property.h"

#include "resource-manager.h"

using namespace Guikachu;

ID::ID (notify_signal_t   &notify_signal,
	ResourceManager   *owner_,
	const std::string &value):
    Property<std::string> (notify_signal, value),
    owner (owner_)
{
}

void ID::set_val (const std::string &value_)
{
    std::string real_id = owner->validate_id (value_);

    if (owner->rename_resource (value, real_id))
	Property<std::string>::set_val (real_id);
}

namespace Guikachu
{


// The following is needed to make sure the object really contains the
// required specializations
namespace
{
    static void foo ()
    {
	VSignal s;
	
	Property<std::string>               x1 (s);
	Property<std::vector<std::string> > x2 (s);
    }
    
} // anonymous namespace


    
std::string make_7bit_string (const std::string &str)
{
    std::string ret;

    for (std::string::const_iterator i = str.begin ();
	 i != str.end (); ++i)
    {
	// Convert non-ASCII characters to _ placeholder
	if ((signed char)*i < 0)
	    ret += '_';
	else
	    ret += *i;
    }

    return ret;
}
    
template<>
void Property<std::string>::set_val (const std::string &value_)
{
    std::string ascii_value = make_7bit_string (value_);

    if (ascii_value == value)
	return;

    value = ascii_value;
    changed ();
}

template<>
void Property<std::vector<std::string> >::set_val (const std::vector<std::string> &value_)
{
    std::vector<std::string> ascii_values (value_.size ());
    std::transform (value_.begin (), value_.end (),
		    ascii_values.begin (), make_7bit_string);

    if (ascii_values == value)
	return;

    value = ascii_values;
    changed ();
}

std::string escape_backslashes (const std::string &src)
{
    std::string escaped_string;

    for (std::string::const_iterator i = src.begin (); i != src.end (); ++i)
    {
	if (*i == '\\')
	{
	    // Peek at next character
	    std::string::const_iterator next = i;
	    next++;
	    
	    if (next != src.end ())
	    {
		// Pass double backslashes through
		if (*next == '\\')
		{
		    escaped_string += "\\\\";
		    i++;
		    continue;
		}
		
		// Don't pass single backslashes from before quotes
		if (*next == '"')
		{
		    i++;
		    continue;
		}
		
	    } else {
		
		// This is a trailing single backslash so convert it
		// to double backslash
		escaped_string += "\\\\";
		break;
	    }
	} 
	
	if (*i == '"')
	{
	    escaped_string += "\\\"";
	    continue;
	}

	escaped_string += *i;
    }

    return escaped_string;
}

template<>
std::ostream & operator<< (std::ostream &ostr, const Property<std::string> &prop)
{
    ostr << escape_backslashes (prop.value);
    return ostr;
}
    
} // namespace Guikachu
