//$Id: popup-trigger.cc,v 1.26 2003/06/30 14:07:58 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger.h"

#include "form-editor.h"

using Guikachu::Widgets::PopupTrigger;
using namespace Guikachu::GUI::FormEditor;

PopupTrigger::PopupTrigger (Resources::Form   *owner,
			    const std::string &id,
			    serial_t           serial):
    Widget (owner, id, serial),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),

    list_id (changed, owner),
    usable (changed, true),
    anchor_right (changed, false)
{
}

int PopupTrigger::get_auto_width () const
{
    return 16 + get_line_width (font, text);
}

int PopupTrigger::get_auto_height () const
{
    return get_font_height (font);
}
