//$Id: form-editor.cc,v 1.27 2003/06/30 14:07:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-editor/form-editor.h"

#include "preferences.h"
#include "resource-manager.h"
#include "target.h"

using namespace Guikachu::GUI;
using Guikachu::GUI::FormEditor::Font;

#define GUIKACHU_TITLE_FONT 1

const Font &FormEditor::get_font (int font_num)
{
    static Font standard_fonts[8];
    static bool init[8] = {false, false, false, false, false, false, false, false};

    if (!init[font_num])
    {
        std::string font_filename;
        
        switch (font_num)
        {
        case 0:
            font_filename = "stdfont.txt";
            break;
        case 1:
            font_filename = "boldfont.txt";
            break;
        case 2:
            font_filename = "bigfont.txt";
            break;
        case 3:
            font_filename = "symbol.txt";
            break;
        case 4:
            font_filename = "symbol11.txt";
            break;
        case 5:
            font_filename = "symbol7.txt";
            break;
        case 6:
            font_filename = "ledfont.txt";
            break;
        case 7:
            font_filename = "bigbold.txt";
            break;
        default:
            g_assert_not_reached ();
            break;
        }
        
        standard_fonts[font_num].parse (font_filename);
        init[font_num] = true;
    }
    
    return standard_fonts[font_num];
}


const Font &FormEditor::get_title_font ()
{
    return get_font (GUIKACHU_TITLE_FONT);
}

int FormEditor::get_font_height (int font_num)
{
    const Font &font = get_font (font_num);
    return font.get_line_height ();
}

int FormEditor::get_line_width (int font_num, const std::string &text)
{
    const Font &font = get_font (font_num);
    return font.get_line_width (text);
}

void FormEditor::get_text_extents (int font_num, const std::string &text,
				   int &width, int &height)
{
    const Font &font = get_font (font_num);
    font.get_text_extents (text, width, height);
}

std::string FormEditor::get_foreground_color (bool enabled)
{   
    if (enabled)
	return Preferences::FormEditor::get_color_fg ();
    else
	return Preferences::FormEditor::get_color_disabled ();
}

std::string FormEditor::get_background_color ()
{
    return Preferences::FormEditor::get_color_bg ();
}

std::string FormEditor::get_selection_color ()
{
    return Preferences::FormEditor::get_color_selection ();
}
