//$Id: form-editor-canvas.h,v 1.2 2003/06/30 14:07:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_CANVAS_H
#define GUIKACHU_FORM_EDITOR_CANVAS_H

#include <gnome--/canvas.h>
#include <gtk/gtkpacker.h> /* For GtkAnchor */

#include "form-editor/font.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    Gnome::CanvasItem* draw_text   (Gnome::CanvasGroup &group,
					    const std::string  &text,
					    int                 font_num,
					    int                 x,
					    int                 y,
					    bool                usable,
					    bool                multi_line = false,
					    GtkAnchorType       anchor = GTK_ANCHOR_NW,
					    int                 clip_width = 0,
					    int                 clip_height = 0);

	    Gnome::CanvasItem* render_text (Gnome::CanvasGroup &group,
					    const std::string  &text,
					    const Font         &font,
					    const Gdk_Color    &color,
					    int                 x,
					    int                 y,
					    bool                multi_line = false,
					    GtkAnchorType       anchor = GTK_ANCHOR_NW,
					    int                 clip_width = 0,
					    int                 clip_height = 0);

	    // Use this instead of Rectangle canvas items because
	    // those are shoddy
	    Gnome::CanvasItem* draw_rectangle (Gnome::CanvasGroup &group,
					       int x1, int y1,
					       int x2, int y2);
	    
	    Gnome::CanvasItem* draw_pixbuf (Gnome::CanvasGroup &group,
					    GdkPixbuf          *pixbuf,
					    int                 x = 0,
					    int                 y = 0);
	}
    }
}
    
#endif /* !GUIKACHU_FORM_EDITOR_CANVAS_H */
