//$Id: text.cc,v 1.11 2003/01/31 20:58:42 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "text.h"

#include <algorithm>

using namespace Guikachu::GUI::PropertyEditors;

TextArea::TextArea (property_t   &property_,
		    op_factory_t *op_factory_):
    PropertyEditor (this),
    property (property_),
    op_factory (op_factory_),
    update_block (false),
    cursor_pos (-1)
{
    using SigC::slot;

    add (text_widget);
    set_policy (GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    text_widget.set_word_wrap (true);
    text_widget.set_editable (true);
    
    text_widget.changed.connect (slot (this, &TextArea::changed_cb));
    
    property.changed.connect (slot (this, &TextArea::update));
    update ();
}

void TextArea::changed_cb ()
{
    if (update_block)
        return;

    cursor_pos = text_widget.get_position ();

    char *text_chars = gtk_editable_get_chars (
	GTK_EDITABLE (text_widget.gtkobj ()), 0, text_widget.get_length ());

    if (property != text_chars)
    {
	op_factory->push_change (text_chars);
    }
    
    g_free (text_chars);
}

void TextArea::update ()
{
    update_block = true;
    text_widget.freeze ();

    if (text_widget.get_length ())
	text_widget.delete_text (0, text_widget.get_length ());
    text_widget.insert (property);

    if (cursor_pos >= 0 && cursor_pos <= int (text_widget.get_length ()))
	gtk_editable_set_position (GTK_EDITABLE (text_widget.gtkobj ()), cursor_pos);
    
    text_widget.thaw ();
    update_block = false;
}
