//$Id: entry.cc,v 1.11 2002/10/12 21:31:08 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "entry.h"

#include <sigc++/retbind.h>
#include "argumentsink.h"

using namespace Guikachu::GUI::PropertyEditors;

Entry::Entry (bool          live_update,
	      property_t   &property_,
	      op_factory_t *op_factory_):
    PropertyEditor (this),
    property (property_),
    op_factory (op_factory_),
    update_block (false),
    cursor_pos (-1)
{
    using namespace SigC;
    
    if (live_update)
    {
	changed.connect (slot (this, &Entry::changed_cb));
    } else {
	activate.connect (slot (this, &Entry::changed_cb));
	Slot0<int> activate_slot = retbind (slot (this, &Entry::changed_cb), 0);
	focus_out_event.connect (SigC::hide <int, GdkEventFocus*> (activate_slot));
    }

    property.changed.connect (slot (this, &Entry::update));
    update ();
}

void Entry::changed_cb ()
{
    if (update_block)
        return;

    update_block = true;

    const std::string new_val = get_text ();

    if (property != new_val)
    {
	cursor_pos = get_position ();
	
	op_factory->push_change (new_val);
    }
    
    update_block = false;
    
    update ();
}

void Entry::update ()
{
    update_block = true;

    set_text (property);
    if (cursor_pos >= 0)
	set_position (cursor_pos + 1);
    
    update_block = false;
}
