//$Id: resource-manager.h,v 1.27 2003/01/25 00:33:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_MANAGER_H
#define GUIKACHU_RESOURCE_MANAGER_H

namespace Guikachu
{
    class ResourceManager;
}

#include "resource.h"
#include "app-res.h"
#include "target.h"

#include "undo.h"

#include <map>
#include <set>
#include <sigc++/signal_system.h>
#include <time.h>

namespace Guikachu
{
    class NoCase
    {
    public:
	int  compare     (const std::string &x, const std::string &y) const;
	bool operator () (const std::string &x, const std::string &y) const;
    };

    // Forward declarations
    class Target;
    
    class ResourceManager: public SigC::Object
    {
	typedef std::map<std::string, Resource*, NoCase> resource_map_t;
	typedef std::set<std::string, NoCase> id_set_t;
	
	resource_map_t         resource_map;
	id_set_t               id_set;
	Resources::Application app;
	Target                 target;

	UndoManager            undo_manager;
	
	bool                   dirty;
	time_t                 modification_time;

    public:
	ResourceManager  ();
	~ResourceManager ();
	
	Resource* create_resource (Resources::Type type,
				   std::string     id = "",
				   bool            try_alternate_names = false);
	void remove_resource (Resource *resource);
	bool rename_resource (const std::string &old_id,
			      const std::string &new_id);

	bool register_id   (const std::string &id);
	void unregister_id (const std::string &id);

	std::string create_id   (const std::string &prefix);
	std::string validate_id (std::string id);

	std::set<Resource*>     get_resources   () const;
	Resource*               get_resource    (const std::string &id) const;
	Resources::Application* get_application () { return &app; };
	Target*                 get_target      () { return &target; };

	UndoManager& get_undo_manager () { return undo_manager; };
	
	// Signals
	SigC::Signal1<void, Resource*> resource_created;
	SigC::Signal1<void, Resource*> resource_removed;
       SigC::Signal0<void> dirty_state_changed;
	
	bool   is_dirty ();
	time_t get_modification_time ();
	
	void clear_dirty ();
	void set_dirty ();
    };
}

#endif /* !GUIKACHU_RESOURCE_MANAGER_H */
