//$Id: form-win-helpers.h,v 1.12 2002/10/27 22:17:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_WIN_HELPERS_H
#define GUIKACHU_FORM_WIN_HELPERS_H

#include "form-win.h"

#include <gtk--/treeitem.h>
#include <gtk--/menu.h>
#include <gtk--/label.h>

#include <gnome--/canvas.h>
#include <gnome--/canvas-rect.h>

#include "form-editor/widget-ops.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormWindow_Helpers
	{
	    class CanvasSelectionWrapper: public SigC::Object
	    {
		Gnome::Canvas     &canvas;
		Gnome::CanvasRect *rubber_box;
		
	    public:
		CanvasSelectionWrapper (Gnome::Canvas &canvas);
		~CanvasSelectionWrapper ();
		
		SigC::Signal4<void, int, int, int, int> selection;

		void set_active (bool active);
		
	    private:
		bool   dragging;
		bool   active;
		double selection_start_x, selection_start_y;
		
		void selection_begin (GdkEventButton *e);
		void selection_drag  (GdkEventMotion *e);
		void selection_end   (GdkEventButton *e);
	    };

	    
	    class WidgetTreeItem: public Gtk::TreeItem
	    {
		Guikachu::Widget *widget;
		Gtk::Menu         popup_menu;
		Gtk::Label        label;
	    public:
		WidgetTreeItem (Guikachu::Widget *widget);
		SigC::Signal0<void> activate;

		SigC::Signal0<void> menu_edit;
		SigC::Signal0<void> menu_remove;
	    private:
		void update ();
		void remove_cb ();
		int button_press_cb (GdkEventButton *e);
		void widget_selected_cb (bool selected);
	    };

	    
	    class TopTreeItem: public Gtk::TreeItem
	    {
		Resources::Form *res;
		Gtk::Menu        popup_menu;
		Gtk::Label       label;
	    public:
		TopTreeItem (Resources::Form *res);
		SigC::Signal0<void> activate;

		SigC::Signal0<void> menu_edit;
	    private:
		void update ();
		int button_press_cb (GdkEventButton *e);
	    };
	    
	    
	    
    
	    
	    class FormMoveOp: public UndoOp
	    {
		std::string label;

		ResourceManager *manager;
		std::string form_id;

		int old_x, old_y;
		int new_x, new_y;

	    public:
		FormMoveOp (Resources::Form *form, int new_x, int new_y);
		virtual ~FormMoveOp () {};

		void undo ();
		void redo ();
		std::string get_label () const { return label; };
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_WIN_HELPERS_H */
