//$Id: label.cc,v 1.31 2003/01/31 20:58:41 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label.h"
#include "label-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::Label;
using namespace Guikachu::GUI::FormEditor;

Label::Label (Resources::Form   *owner,
	      const std::string &id):
    Widget (owner, id),
    Textual (changed, id),
    editor (0),
    usable (changed, true)
{
}

Label::~Label ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Label::create_editor ()
{
    if (!editor)
	editor = new LabelProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* Label::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new LabelCanvasItem (this, parent_group);
}

int Label::get_width  () const
{
    int width = 0, height = 0;
    GUI::FormEditor::get_text_extents (font, text, width, height);

    return width;
}

int Label::get_height () const
{
    int width = 0, height = 0;
    GUI::FormEditor::get_text_extents (font, text, width, height);

    return height;
}
