//$Id: checkbox-prop.cc,v 1.16 2002/10/27 22:17:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "checkbox-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widget-prop.h"
#include "auto-resizeable-prop.h"
#include "textual-prop.h"


#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"

#include "property-ops-widget.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

CheckboxProperties::CheckboxProperties (Checkbox *res)
{
    using namespace SigC;
    using WidgetOps::PropChangeOpFactory;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Label */
    TextualProperties::add_controls (res, *proptable);

    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (
	res->usable,
	new PropChangeOpFactory<bool> (
	    _("Toggle usable state of %s"), res, res->usable, false));
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Group ID */
    control = new GUI::PropertyEditors::NumEntry(
	0, 65535, res->group,
	new PropChangeOpFactory<int> (_("Change group ID of %s"), res, res->group, true));
    proptable->add (_("_Group ID:"), *manage (control),
		    _("Only one checkbox can be selected "
		      "per group (select 0 for non-exclusive "
		      "check boxes)"));
    /* Toggled */
    control = new GUI::PropertyEditors::ToggleButton (
	res->toggled,
	new PropChangeOpFactory<bool> (_("Toggle %s"), res, res->toggled, false));	
    proptable->add (_("_Toggled:"), *manage (control));
    
    /* Alignment */
    control = new GUI::PropertyEditors::ToggleButton (
	res->anchor_right,
	new PropChangeOpFactory<bool> (_("Change alignment of %s"), res, res->anchor_right, false));
    proptable->add (_("_Anchor right:"), *manage (control),
		    _("Keep right aligned when changing label "
		      "text at run-time"));

    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);

    /* Size */
    AutoWidthProperties::add_controls  (res, *proptable);
    AutoHeightProperties::add_controls (res, *proptable);
    
    proptable->show ();
    property_editor = proptable;
}

CheckboxProperties::~CheckboxProperties ()
{
    delete property_editor;
}

Gtk::Widget* CheckboxProperties::get_editor ()
{
    return property_editor;
}
