//$Id: button.cc,v 1.36 2002/06/14 21:37:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button.h"
#include "button-canvas.h"
#include "button-prop.h"

#include "form-editor.h"

using Guikachu::Widgets::Button;
using namespace Guikachu::GUI::FormEditor;

Button::Button (Resources::Form   *owner,
		const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),
    
    editor (0),
    frame (changed, FRAME_SIMPLE),
    usable (changed, true),
    repeat (changed, false),
    anchor_right (changed, false)
{
}

Button::~Button ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Button::create_editor ()
{
    if (!editor)
	editor = new ButtonProperties (this);

    return editor->get_editor ();
}

WidgetCanvasItem* Button::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new ButtonCanvasItem (this, parent_group);
}

int Button::get_auto_width () const
{
    return 6 + get_line_width (font, text) + 6;
}

int Button::get_auto_height () const
{
    int text_height = get_font_height (font);

    if (frame == FRAME_SIMPLE)
	text_height += 2;
    if (frame == FRAME_BOLD)
	text_height += 1;
	
    return text_height;
}
