//$Id: button-canvas.cc,v 1.23 2002/10/27 22:17:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button-canvas.h"

#include "form-editor.h"
#include "resizeable-ops.h"

using namespace Guikachu::GUI::FormEditor;

ButtonCanvasItem::ButtonCanvasItem (Widgets::Button    *widget_,
				    Gnome::CanvasGroup *parent_group):
    CanvasItem (widget_, parent_group),
    WidgetCanvasItem (widget_, parent_group),
    ResizeableCanvasItem (widget_, parent_group, new WidgetOps::ResizeOpFactory (widget_)),
    widget (widget_),
    group (0)
{
    update ();
}

static void free_pixdata_gfree (guchar *pixels, gpointer closure)
{
    g_free (pixels);
}

void ButtonCanvasItem::create_simple_border ()
{
    int x1 = widget->x;
    int y1 = widget->y;

    int width = widget->get_width ();
    int height = widget->get_height ();

    int pix_height = height + 2;
    int pix_width = width + 2;
    
    guchar    *pixdata = g_new0 (guchar, pix_width * pix_height * 4);
    Gdk_Color  color (get_foreground_color (widget->usable));
    
#define _GUIKACHU_OFFSET(x,y)				\
    (MIN (MAX (0, (y)), (pix_height - 1)) * pix_width +	\
     MIN (MAX (0, (x)), (pix_width - 1))) * 4

#define _GUIKACHU_PLOT(x,y)					\
    {								\
	pixdata[_GUIKACHU_OFFSET(x,y) + 0] = color.red   >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x,y) + 1] = color.green >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x,y) + 2] = color.blue  >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x,y) + 3] = 255;		\
    }

    // N and S border
    for (int x = 3; x < width - 1; x++)
    {
	_GUIKACHU_PLOT (x, 0);
	_GUIKACHU_PLOT (x, height);
    }
    
    // W and E border
    for (int y = 3; y < height - 2; y++)
    {
	_GUIKACHU_PLOT (0, y);
	_GUIKACHU_PLOT (width + 1, y);
    }

    // NW corner
    _GUIKACHU_PLOT (1, 1);
    _GUIKACHU_PLOT (2, 1);
    _GUIKACHU_PLOT (1, 2);

    // NE corner
    _GUIKACHU_PLOT (width, 1);
    _GUIKACHU_PLOT (width - 1, 1);
    _GUIKACHU_PLOT (width, 2);

    // SE corner
    _GUIKACHU_PLOT (width - 1, height - 1);
    _GUIKACHU_PLOT (width, height - 1);
    _GUIKACHU_PLOT (width, height - 2);

    // SW corner
    _GUIKACHU_PLOT (1, height - 1);
    _GUIKACHU_PLOT (2, height - 1);
    _GUIKACHU_PLOT (1, height - 2);

#undef _GUIKACHU_PLOT
    
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_data (pixdata,
						  GDK_COLORSPACE_RGB, true, 8,
						  pix_width, pix_height,
						  pix_width * 4,
						  free_pixdata_gfree, 0);
    FormEditor::draw_pixbuf (*group, pixbuf, x1 - 1, y1 - 1);
    FormEditor::draw_rectangle (*group,
				x1 - 1, y1 - 1,
				x1 + width + 1, y1 + height + 2);

    gdk_pixbuf_unref (pixbuf);
}

void ButtonCanvasItem::create_bold_border ()
{
    int x1 = widget->x;
    int y1 = widget->y;

    int width = widget->get_width ();
    int height = widget->get_height ();

    const int pix_height = height + 4;
    const int pix_width = width + 4;

    guchar    *pixdata = g_new0 (guchar, pix_width * pix_height * 4);
    Gdk_Color  color (get_foreground_color (widget->usable));

#define _GUIKACHU_PLOT(x,y)					\
    {								\
	pixdata[_GUIKACHU_OFFSET(x, y) + 0] = color.red   >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x, y) + 1] = color.green >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x, y) + 2] = color.blue  >> 8;	\
	pixdata[_GUIKACHU_OFFSET(x, y) + 3] = 255;		\
    }

    // N and S border
    for (int x = 6; x < width - 2; x++)
    {
	_GUIKACHU_PLOT (x, 0);
	_GUIKACHU_PLOT (x, 1);
	
	_GUIKACHU_PLOT (x, height + 2);
	_GUIKACHU_PLOT (x, height + 3);
    }

    // W and E border
    for (int y = 5; y < height - 1; y++)
    {
	_GUIKACHU_PLOT (0, y);
	_GUIKACHU_PLOT (1, y);
	
	_GUIKACHU_PLOT (width + 2, y);
	_GUIKACHU_PLOT (width + 3, y);
    }

    // NW corner
    const int corner_width = 5;
    const int corner_height = 6;
    const char *corner_nw[] = {
	"    X",
	"  XXX",
	" XXXX",
	"XXX  ",
	"XX   ",
	" X   " };

    const char *corner_ne[] = {
	"X    ",
	"XXX  ",
	"XXXX ",
	"  XXX",
	"   XX",
	"   X " };

    const char *corner_se[] = {
	"   X ",
	"   XX",
	"  XXX",
	"XXXX ",
	"XXX  ",
	"X    " };

    const char *corner_sw[] = {
	" X   ",
	"XX   ",
	"XXX  ",
	" XXXX",
	"  XXX",
	"    X" };

    for (int parse_y = 0; parse_y < corner_height; parse_y++)
	for (int parse_x = 0; parse_x < corner_width; parse_x++)
	{
	    if (corner_nw[parse_y][parse_x] != ' ')
		_GUIKACHU_PLOT (1 + parse_x, parse_y);
	    if (corner_ne[parse_y][parse_x] != ' ')
		_GUIKACHU_PLOT (width - 2 + parse_x, parse_y);
	    if (corner_se[parse_y][parse_x] != ' ')
		_GUIKACHU_PLOT (width - 2 + parse_x, height - 2 + parse_y);
	    if (corner_sw[parse_y][parse_x] != ' ')
		_GUIKACHU_PLOT (1 + parse_x, height - 2 + parse_y);
	}
    
#undef _GUIKACHU_PLOT
    
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_data (pixdata,
						  GDK_COLORSPACE_RGB, true, 8,
						  pix_width, pix_height,
						  pix_width * 4,
						  free_pixdata_gfree, 0);
    FormEditor::draw_pixbuf (*group, pixbuf, x1 - 2, y1 - 2);
    FormEditor::draw_rectangle (*group,
				x1 - 2, y1 - 2,
				x1 + width + 3, y1 + height + 3);

    gdk_pixbuf_unref (pixbuf);
}

void ButtonCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*draw_group, 0, 0);
    
    int width = widget->get_width ();
    int height = widget->get_height ();
    
    int x1 = widget->x;
    int x2 = x1 + width;
    int y1 = widget->y;
    int y2 = y1 + height;

    if (widget->frame == Widgets::Button::FRAME_SIMPLE)
	create_simple_border ();

    if (widget->frame == Widgets::Button::FRAME_BOLD)
	create_bold_border ();
	
    int text_x = x1 + width / 2;
    int text_y = y1 + height / 2 - 1;

    FormEditor::draw_text (*group,
			   widget->text, widget->font,
			   text_x, text_y,
			   widget->usable,
			   false,
			   GTK_ANCHOR_CENTER,
			   width, height);
    
    set_canvas_item (group);
}

void ButtonCanvasItem::get_bounds (int &x1, int &y1,
				   int &x2, int &y2)
{
    x1 = widget->x;
    y1 = widget->y;
    x2 = x1 + widget->get_width ();
    y2 = y1 + widget->get_height ();
}
