//$Id: add-resource.cc,v 1.21 2003/01/25 00:33:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "add-resource.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/optionmenu.h>
#include <gtk--/menu.h>

#include "resource-manager.h"
#include "resource-manager-ops.h"

#include "mainwin.h"

using namespace Guikachu;

GUI::AddResourceWin::AddResourceWin (ResourceManager *manager_):
    gui (glade_xml_new (GUIKACHU_GLADEDIR "/guikachu.glade", "dlg_add")),
    dialog (Gtk::wrap (GNOME_DIALOG (glade_xml_get_widget (gui, "dlg_add")))),
    entry (Gtk::wrap (GTK_ENTRY (glade_xml_get_widget (gui, "add_name")))),
    manager (manager_)
{
    Gtk::OptionMenu *optmenu;
    Gtk::Menu       *menu;
    
    optmenu = Gtk::wrap (GTK_OPTION_MENU (glade_xml_get_widget (gui, "add_type")));

    menu = optmenu->get_menu ();
    menu->items ().clear ();
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("Form"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_FORM)));
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("Dialog"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_DIALOG)));
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("Menu"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_MENU)));
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("String"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_STRING)));
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("String list"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_STRINGLIST)));
    menu->items ().push_back (Gtk::Menu_Helpers::MenuElem
			      (_("Free-text blob"),
			       SigC::bind (
				   SigC::slot (this, &AddResourceWin::resource_type_cb),
				   Resources::RESOURCE_BLOB)));

    optmenu->set_history (0);
    res_type = Resources::RESOURCE_FORM;

    dialog->editable_enters (*entry);
    dialog->close_hides (true);
}

GUI::AddResourceWin::~AddResourceWin ()
{
//    dialog->destroy ();
    gtk_widget_destroy (GTK_WIDGET (dialog->gtkobj ()));
    gtk_object_unref (GTK_OBJECT (gui));
}

void GUI::AddResourceWin::run ()
{
    int dialog_result;

    dialog_result = dialog->run_and_close ();

    if (dialog_result == 0)
    {
	std::string id = entry->get_text ();
	
	Resource *res = manager->create_resource (res_type, id);
	if (!res)
	{
	    char *error_msg = g_strdup_printf (_("Non-unique identifier `%s'"), id.c_str ());
	    GUI::show_error (error_msg);
	    g_free (error_msg);

	    return;
	}
	
	manager->get_undo_manager ().push (new ResourceOps::CreateOp (res));
    }
}

void GUI::AddResourceWin::resource_type_cb (Resources::Type type)
{
    res_type = type;
}
