//$Id: menu-res.cc,v 1.24 2003/01/29 20:29:58 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "menu-res.h"
#include "menu-win.h"

using namespace Guikachu;
using namespace Guikachu::Resources;

Menu::Submenu::Submenu (const std::string &label_) :
    label (make_7bit_string (label_))
{
}

Menu::Menu (ResourceManager   *manager,
	    const std::string &id):
    Resource (manager, id),
    gui (0)
{
}

Menu::~Menu ()
{
    delete gui;
}

void Menu::show_ui ()
{
    if (!gui)
	gui = new GUI::MenuWindow (this);

    gui->show ();
}

void Menu::register_menu (const MenuTree &new_submenus)
{
    submenus = new_submenus;
    
    for (MenuTree::iterator i = submenus.begin (); i != submenus.end (); ++i)
    {
	for (std::vector<MenuItem>::iterator j = i->items.begin (); j != i->items.end (); ++j)
	{
	    if (!j->separator)
	    {
		j->id = make_7bit_string (j->id);
		j->label = make_7bit_string (j->label);
		
		if (!manager->register_id (j->id))
		{
		    j->id = manager->create_id (j->id + "_");
		    manager->register_id (j->id);
		}
	    }
	}
    }
}

void Menu::deregister_menu ()
{
    for (MenuTree::const_iterator i = submenus.begin (); i != submenus.end (); ++i)
    {
	for (std::vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); ++j)
	{
	    if (!j->separator)
		manager->unregister_id (j->id);
	}
    }
}

void Menu::set_submenus (const std::vector<Menu::Submenu>& new_menu)
{
    deregister_menu ();
    register_menu (new_menu);
    
    changed ();
}
