//$Id: selector-trigger.cc,v 1.23 2002/06/14 21:37:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "selector-trigger.h"
#include "selector-trigger-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::SelectorTrigger;
using namespace Guikachu::GUI::FormEditor;

SelectorTrigger::SelectorTrigger (Resources::Form   *owner,
				  const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),
    
    editor (0),
    usable (changed, true),
    anchor_right (changed, false)
{
}

SelectorTrigger::~SelectorTrigger ()
{
    if (editor)
	delete editor;
}

Gtk::Widget* SelectorTrigger::create_editor ()
{
    if (!editor)
	editor = new SelectorTriggerProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* SelectorTrigger::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new SelectorTriggerCanvasItem (this, parent_group);
}

int SelectorTrigger::get_auto_width () const
{
    int text_width = get_line_width (font, text);
    return 6 + text_width;
}

int SelectorTrigger::get_auto_height () const
{
    int text_height = get_font_height (font);
    return text_height + 1;
}
