//$Id: pushbutton.cc,v 1.24 2002/06/14 21:37:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton.h"
#include "pushbutton-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::PushButton;
using namespace Guikachu::GUI::FormEditor;

PushButton::PushButton (Resources::Form   *owner,
			const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),
    
    editor (0),
    usable (changed, true),
    group (changed)
{
}

PushButton::~PushButton ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *PushButton::create_editor ()
{
    if (!editor)
	editor = new PushButtonProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* PushButton::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new PushButtonCanvasItem (this, parent_group);
}

int PushButton::get_auto_width () const
{
    return get_line_width (font, text) + 6;
}

int PushButton::get_auto_height () const
{
    return get_font_height (font);
}
