//$Id: graffiti.cc,v 1.16 2002/06/19 21:57:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti.h"
#include "graffiti-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Graffiti;
using namespace Guikachu::GUI::FormEditor;

Graffiti::Graffiti (Resources::Form   *owner,
		    const std::string &id):
    Widget (owner, id),
    editor (0)
{
}

Graffiti::~Graffiti ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Graffiti::create_editor ()
{
    if (!editor)
	editor = new GraffitiProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* Graffiti::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new GraffitiCanvasItem (this, parent_group);
}

int Graffiti::get_width () const
{
    return 8;
}

int Graffiti::get_height () const
{
    return 9;
}
