//$Id: edit-ops.h,v 1.2 2003/01/25 23:05:50 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_EDIT_OPS_H
#define GUIKACHU_EDIT_OPS_H

#include "resource-manager.h"
#include "form-editor/widget.h"
#include "storage-node.h"
#include "undo.h"

namespace Guikachu
{
    namespace Edit
    {
	class PasteResourceOp: public UndoOp
	{
	    ResourceManager *manager;
	    std::string      id;

	    Resources::Type type;
	    StorageNode     node;

	    std::string op_label;
	    
	public:
	    PasteResourceOp (Resource *pasted_resource);

	    std::string get_label () const { return op_label; };

	    void undo ();
	    void redo ();
	};

	class PasteResourcesOp: public UndoOp
	{
	    typedef std::list<PasteResourceOp*> paste_ops_t;
	    paste_ops_t paste_ops;

	public:
	    PasteResourcesOp (const std::list<Resource*> &pasted_resources);
	    virtual ~PasteResourcesOp ();

	    std::string get_label () const;

	    void undo ();
	    void redo ();
	};


    	class PasteWidgetOp: public UndoOp
	{
	    ResourceManager *manager;
	    std::string      form_id;
	    std::string      id;

	    Widgets::Type type;
	    StorageNode   node;

	    std::string op_label;
	    
	public:
	    PasteWidgetOp (Widget *pasted_resource);

	    std::string get_label () const { return op_label; };

	    void undo ();
	    void redo ();
	};

	class PasteWidgetsOp: public UndoOp
	{
	    typedef std::list<PasteWidgetOp*> paste_ops_t;
	    paste_ops_t paste_ops;
	    std::string op_label;
	    
	public:
	    PasteWidgetsOp (const std::list<Widget*> &pasted_resources);
	    virtual ~PasteWidgetsOp ();

	    std::string get_label () const { return op_label; };

	    void undo ();
	    void redo ();
	};
    }
}

#endif /* !GUIKACHU_EDIT_OPS_H */
