//$Id: string-list.h,v 1.12 2002/11/10 16:47:04 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_STRING_LIST_H
#define GUIKACHU_WIDGETS_STRING_LIST_H

#include <gtk--/box.h>
#include <gtk--/list.h>
#include <gtk--/button.h>
#include <gtk--/entry.h>

#include "property.h"
#include "property-editor.h"
#include "string-list-ops.h"

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	namespace PropertyEditors
	{
	    class StringList: public PropertyEditor,
			      public Gtk::HBox
	    {
	    protected:
		typedef std::vector<std::string> value_t;
		typedef Property<value_t>        property_t;
		typedef StringListOps::OpFactory op_factory_t;
		
		property_t                  &property;
		std::auto_ptr<op_factory_t>  op_factory;
		
		Gtk::List    list_widget;
		
	    private:
		Gtk::Button *btnAdd, *btnUp, *btnDown, *btnRemove;
		Gtk::Entry   entry;
		Gtk::Box    *buttons;
		
	    public:
		StringList (property_t   &property,
			    op_factory_t *op_factory);
		
		LabelAlignment   get_label_alignment () { return LABEL_ALIGN_TOP; };
		bool             get_resizeable      () { return true; };

	    protected:
		unsigned int get_selected_row ();
		
		bool update_block;
		int  saved_pos;
		void add_button (Gtk::Widget &widget);
		void clear_list ();
		void add_to_list (int index, const std::string &label);
		
		SigC::Signal1<void, unsigned int> item_added;
		SigC::Signal1<void, unsigned int> item_removed;
		SigC::Signal1<void, unsigned int> up;   /* Argument is the _old_ index */
		SigC::Signal1<void, unsigned int> down; /* Argument is the _old_ index */
		
	    protected:
		virtual void update ();		
		void selection_cb ();

	    private:
		void button_add_cb ();
		void button_up_cb ();
		void button_down_cb ();
		void button_remove_cb ();
		
		void entry_activate_cb ();
	    };
	}
    }
}

#endif /* !GUIKACHU_WIDGETS_STRING_LIST_H */
