//$Id: string-res.h,v 1.15 2002/08/01 18:06:01 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_STRING_RES_H
#define GUIKACHU_STRING_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class String;
    }
}

#include "resource.h"

namespace Guikachu
{
    namespace GUI
    {
	class StringWindow;
    }
    
    namespace Resources
    {
	class String: public Resource
	{
	    GUI::StringWindow *gui;
	public:
	    String (ResourceManager *owner, const std::string &id);
	    ~String ();

	    Type get_type () const { return RESOURCE_STRING; };
	    void apply_visitor (ResourceVisitor &visitor) { visitor.visit_resource (this); };
	    void show_ui ();

	    Property<std::string> text;
	};
    };
};

#endif /* !GUIKACHU_STRING_RES_H */
