//$Id: queued-signal.cc,v 1.1 2002/06/22 13:01:08 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 *
 * This portion of the code is written by Martin Schulze <MHL.Schulze@t-online.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "queued-signal.h"

#include <gtk--/main.h>
#include <sigc++/retbind.h>

#include <iostream>

using namespace Guikachu;

QueuedSignal::QueuedSignal () :
    queued (false)
{
}

void QueuedSignal::emit ()
{
    if (!queued)
    {
        queued = true;
        Gtk::Main::idle.connect (SigC::retbind (
            SigC::slot (this, &QueuedSignal::idle_cb), 0));
    }

}

void QueuedSignal::idle_cb ()
{
    if (queued)
    {
	VSignal::emit ();
	queued = false;
    }
}
