//$Id: io.h,v 1.3 2002/08/15 23:10:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_IO_H
#define GUIKACHU_IO_H

#include "resource-manager.h"

#include <libgnomevfs/gnome-vfs.h>

namespace Guikachu
{
    namespace IO
    {
	typedef GnomeVFSResult IOResult;

	std::string create_canonical_uri (const std::string &filename);
	
	class Loader
	{
	public:
	    virtual ~Loader () {};
	    
	    virtual IOResult load (ResourceManager *manager, const std::string &uri) = 0;
	};
	
	class Saver
	{
	public:
	    virtual ~Saver () {};
	    
	    virtual IOResult save (ResourceManager *manager, const std::string &uri) = 0;
	};
    }
}

#endif /* !GUIKACHU_IO_H */
