//$Id: widget.h,v 1.37 2002/08/01 18:06:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_WIDGET_H
#define GUIKACHU_FORM_EDITOR_WIDGET_H

namespace Guikachu
{
    namespace Widgets
    {
	enum Type
	{
	    WIDGET_NONE,
	    WIDGET_LABEL,
	    WIDGET_BUTTON,
	    WIDGET_PUSHBUTTON,
	    WIDGET_GRAFFITI,
	    WIDGET_SELECTOR_TRIGGER,
	    WIDGET_CHECKBOX,
	    WIDGET_LIST,
	    WIDGET_POPUP_TRIGGER,
	    WIDGET_SCROLLBAR,
	    WIDGET_TEXT_FIELD,
	    WIDGET_TABLE,
	    WIDGET_GADGET
	};
    }
    
    class Widget;
}

#include <string>
#include <map>
#include <iostream>
#include <sigc++/basic_signal.h>

#include "form-res.h"
#include "form-editor/widget-canvas.h"
#include "form-editor/form-element.h"
#include "form-editor/widget-visitor.h"

#include "property.h"

namespace Guikachu
{
    class Widget: public virtual FormElement,
		  public SigC::Object
    {
    protected:
	typedef std::map<Gnome::CanvasGroup *,
	    GUI::FormEditor::WidgetCanvasItem*> canvas_item_map_t;
	
	Resources::Form           *owner;
	mutable Gtk::Widget       *editor;
	mutable canvas_item_map_t  canvas_items;
	
	Widget (Resources::Form   *owner,
		const std::string &id);
	
    public:
	virtual ~Widget ();
	
	virtual Widgets::Type get_type () const = 0;

	// Generic visitor hook
	virtual void apply_visitor (WidgetVisitor &visitor) = 0;
	
	// Notification
	QueuedSignal changed;
	
	// Common properties
	ID            id;
	Property<int> x;
	Property<int> y;

	// FormElement implementations
	int get_x () const { return x; };
	int get_y () const { return y; };
	void set_x (int x_) { x = x_; };
	void set_y (int y_) { y = y_; };
	
	// Preview-related methods
	GUI::FormEditor::WidgetCanvasItem *get_canvas_item (Gnome::CanvasGroup *parent_group);
	Gtk::Widget                       *get_editor      ();
	
	virtual Gtk::Widget                       *create_editor      () = 0;
	virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group) = 0;
	
	Resources::Form *get_form    () const;
	ResourceManager *get_manager () const;
    };
}

#endif /* !GUIKACHU_FORM_EDITOR_WIDGET_H */
