//$Id: widget-prop.cc,v 1.9 2002/10/27 22:17:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "property-ops-widget.h"

#include "widgets/entry.h"
#include "widgets/pos-entry.h"

using namespace Guikachu::GUI::FormEditor;

void WidgetProperties::add_position_controls (Widget             *res,
					      GUI::PropertyTable &proptable)
{
    using WidgetOps::PropChangeOpFactory;
    
    Gtk::Widget *control;

    /* X */
    control = new GUI::PropertyEditors::XPosEntry (
	res->get_manager (), res->x,
	new PropChangeOpFactory<int> (_("Move %s"), res, res->x, true));
    proptable.add (_("_X:"), *manage (control),
		   _("Horizontal position of the widget, relative "
		     "to the parent form"));

    /* Y */
    control = new GUI::PropertyEditors::YPosEntry (
	res->get_manager (), res->y,
	new PropChangeOpFactory<int> (_("Move %s"), res, res->y, true));
    proptable.add (_("_Y:"), *manage (control),
		   _("Vertical position of the widget, relative "
		     "to the parent form"));

}

void WidgetProperties::add_general_controls (Widget             *res,
					     GUI::PropertyTable &proptable)
{
    Gtk::Widget *control;

    /* Resource ID */
    control = new GUI::PropertyEditors::Entry (
	false, res->id, new WidgetOps::RenameOpFactory (res));
    proptable.add (_("Resource _ID:"), *manage (control));
}
