//$Id: popup-trigger.cc,v 1.23 2002/06/14 21:37:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger.h"
#include "popup-trigger-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::PopupTrigger;
using namespace Guikachu::GUI::FormEditor;

PopupTrigger::PopupTrigger (Resources::Form   *owner,
			    const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),
    
    editor (0),
    list_id (changed, owner),
    usable (changed, true),
    anchor_right (changed, false)
{
}

PopupTrigger::~PopupTrigger ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *PopupTrigger::create_editor ()
{
    if (!editor)
	editor = new PopupTriggerProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* PopupTrigger::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new PopupTriggerCanvasItem (this, parent_group);
}

int PopupTrigger::get_auto_width () const
{
    return 16 + get_line_width (font, text);
}

int PopupTrigger::get_auto_height () const
{
    return get_font_height (font);
}
