//$Id: label.h,v 1.20 2002/08/01 18:06:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_LABEL_H
#define GUIKACHU_FORM_EDITOR_LABEL_H

namespace Guikachu
{
    namespace Widgets
    {
	class Label;
    }
}

#include "widget.h"
#include "resource.h"
#include "textual.h"

#include "label-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Label: public Widget,
		     public Textual
	{
	    GUI::FormEditor::LabelProperties *editor;
	    
	public:
	    Label (Resources::Form   *owner,
		   const std::string &id);
	    ~Label ();
	    
	    Type get_type () const { return WIDGET_LABEL; };
	    void apply_visitor (WidgetVisitor &visitor) { visitor.visit_widget (this); };

	    // Implementation of FormElement methods
	    int get_width  () const;
	    int get_height () const;
	    
	    Gtk::Widget                       *create_editor ();
	    GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);
	    
	    Property<bool> usable;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_LABEL_H */
