//$Id: gadget.cc,v 1.10 2002/06/14 21:37:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gadget.h"
#include "gadget-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Gadget;
using namespace Guikachu::GUI::FormEditor;

Gadget::Gadget (Resources::Form   *owner,
		const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    editor (0),
    usable (changed, true)
{
    width = 20;
    height = 20;
}

Gadget::~Gadget ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Gadget::create_editor ()
{
    if (!editor)
	editor = new GadgetProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* Gadget::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new GadgetCanvasItem (this, parent_group);
}
