//$Id: form-editor.h,v 1.22 2002/06/02 13:53:41 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_H
#define GUIKACHU_FORM_EDITOR_H

#include <gnome--/canvas.h>
#include <gtk/gtkpacker.h> /* For GtkAnchor */

#include "form-editor/font.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    const Font &get_font (int font_num);
	    const Font &get_title_font ();

	    std::string get_foreground_color (bool enabled);
	    std::string get_background_color ();
	    std::string get_selection_color  ();

	    
	    int  get_font_height  (int font_num);

	    int  get_line_width   (int                font_num,
				   const std::string &text);
	    
	    void get_text_extents (int                font_num,
				   const std::string &text,
				   int               &width,
				   int               &height);
	    
	    
	    Gnome::CanvasItem* draw_text   (Gnome::CanvasGroup &group,
					    const std::string  &text,
					    int                 font_num,
					    int                 x,
					    int                 y,
					    bool                usable,
					    bool                multi_line = false,
					    GtkAnchorType       anchor = GTK_ANCHOR_NW,
					    int                 clip_width = 0,
					    int                 clip_height = 0);

	    Gnome::CanvasItem* render_text (Gnome::CanvasGroup &group,
					    const std::string  &text,
					    const Font         &font,
					    const Gdk_Color    &color,
					    int                 x,
					    int                 y,
					    bool                multi_line = false,
					    GtkAnchorType       anchor = GTK_ANCHOR_NW,
					    int                 clip_width = 0,
					    int                 clip_height = 0);

	    // Use this instead of Rectangle canvas items because
	    // those are shoddy
	    Gnome::CanvasItem* draw_rectangle (Gnome::CanvasGroup &group,
					       int x1, int y1,
					       int x2, int y2);
	    
	    Gnome::CanvasItem* draw_pixbuf (Gnome::CanvasGroup &group,
					    GdkPixbuf          *pixbuf,
					    int                 x = 0,
					    int                 y = 0);
	}
    }
}
    
#endif /* !GUIKACHU_FORM_EDITOR_H */
