//$Id: resource-tree.h,v 1.3 2002/08/17 13:48:24 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_TREE_H
#define GUIKACHU_RESOURCE_TREE_H

namespace Guikachu
{
    namespace GUI
    {
	class TreeItem;
    }
}

#include "resource.h"
#include "resource-manager.h"

#include <gtk--/tree.h>
#include <map>

namespace Guikachu
{
    namespace GUI
    {
	class ResourceTree: public Gtk::Tree
	{
	    typedef std::map<Resources::Type, Gtk::TreeItem*>     subtree_map;
	    typedef std::map<Resource*, Guikachu::GUI::TreeItem*> treeitem_map;

	    ResourceManager *manager;
	    
	    Gtk::Tree     *main_tree;
	    Gtk::TreeItem *top_item;
	    subtree_map    subtrees;
	    treeitem_map   treeitems;

	public:
	    ResourceTree ();

	    void set_manager  (ResourceManager *manager);
	    
	private:
	    void create_tree_for_type (Resources::Type    type,
				       const std::string &category_name);

	    void resource_created_cb (Resource *res);
	    void resource_removed_cb (Resource *res);
	};
    }
}

#endif /* !GUIKACHU_RESOURCE_TREE_H */
