//$Id: resource-manager-ops.h,v 1.2 2002/08/27 20:13:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_MANAGER_OPS_H
#define GUIKACHU_RESOURCE_MANAGER_OPS_H

#include "resource-manager.h"
#include "storage-node.h"

namespace Guikachu
{    
    class ResourceRemoveOp: public UndoOp
    {
	Resource         *resource;
	ResourceManager  *manager;
	
	Resources::Type   type;
	std::string       id;
	StorageNode       node;
	
	std::string      label;
	
    public:
	ResourceRemoveOp (Resource *resource);
	virtual ~ResourceRemoveOp ();
	
	std::string get_label () const;
	
	void undo ();
	void redo ();
    };

    class ResourceCreateOp: public UndoOp
    {
	ResourceManager *manager;

	Resources::Type  type;
	std::string      id;

	std::string      label;
	
    public:
	ResourceCreateOp (Resource *resource);
	virtual ~ResourceCreateOp ();
	
	std::string get_label () const;
	
	void undo ();
	void redo ();	
    };
}

#endif /* !GUIKACHU_RESOURCE_MANAGER_OPS_H */
