//$Id: resource-manager-ops.cc,v 1.2 2002/08/27 20:13:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "resource-manager-ops.h"
#include "io/xml-loader.h"
#include "io/xml-saver.h"

using namespace Guikachu;

ResourceRemoveOp::ResourceRemoveOp (Resource *resource_):
    resource (resource_),
    manager (resource->get_manager ()),
    type (resource->get_type ()),
    id (resource->id)
{
    char *tmp = g_strdup_printf (_("Removing %s"), id.c_str ());
    label = tmp;
    g_free (tmp);
    
    IO::XML::ResourceSaver saver (node);
    resource->apply_visitor (saver);
}

ResourceRemoveOp::~ResourceRemoveOp ()
{
}

std::string ResourceRemoveOp::get_label () const
{
    return label;
}

void ResourceRemoveOp::undo ()
{
    resource = manager->create_resource (type, id);
    IO::XML::ResourceLoader loader (node);
    
    resource->apply_visitor (loader);
}

void ResourceRemoveOp::redo ()
{
    manager->remove_resource (resource);
}


ResourceCreateOp::ResourceCreateOp (Resource *resource):
    manager (resource->get_manager ()),
    type (resource->get_type ()),
    id (resource->id)
{
    char *tmp = g_strdup_printf (_("Creating %s"), id.c_str ());
    label = tmp;
    g_free (tmp);
}

ResourceCreateOp::~ResourceCreateOp ()
{
}

std::string ResourceCreateOp::get_label () const
{
    return label;
}

void ResourceCreateOp::undo ()
{
    manager->remove_resource (manager->get_resource (id));
}

void ResourceCreateOp::redo ()
{
    manager->create_resource (type, id);
}
