//$Id: io.cc,v 1.1 2002/08/16 18:55:32 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "io/io.h"

using namespace Guikachu;

std::string IO::create_canonical_uri (const std::string &filename)
{
    if (filename == "")
	return "";

    if (filename.find ("://") < filename.find ("/"))
	// Don't touch URI's
	return filename;
    
    std::string full_filename;
    if (g_path_is_absolute (filename.c_str ()))
	full_filename = filename;
    else {
	char *current_dirname = g_get_current_dir ();
	full_filename = std::string (current_dirname) + "/" + filename;
	g_free (current_dirname);
    }
    
    char *uri_tmp = gnome_vfs_make_uri_canonical (full_filename.c_str ());
    std::string uri = uri_tmp;
    g_free (uri_tmp);
    
    return uri;
}
