//$Id: widget-canvas.h,v 1.6 2002/06/22 13:01:09 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_WIDGET_CANVAS_H
#define GUIKACHU_FORM_EDITOR_WIDGET_CANVAS_H

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class WidgetCanvasItem;
	}
    }
}

#include <sigc++/basic_signal.h>
#include <gtk--/menu.h>

#include "canvasitem.h"
#include "widget.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class WidgetCanvasItem: public virtual CanvasItem
	    {
		Widget             *widget;

		Gtk::Menu           popup_menu;
		
	    protected:
		WidgetCanvasItem (Widget             *widget,
				  Gnome::CanvasGroup *parent_group);		
	    public:
		virtual ~WidgetCanvasItem ();

	    protected:
		// Selection
		bool selected;
		Gnome::CanvasItem *selection_box;
		virtual Gnome::CanvasItem * create_selection_box ();

	    public:
		SigC::Signal0<void> menu_edit;
		SigC::Signal0<void> menu_remove;
		
	    private:
		void canvas_item_changed_cb ();
		
		void widget_selected_cb (bool      selected);
		void canvas_event_cb    (GdkEvent *event);
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_WIDGET_CANVAS_H */
