//$Id: app-res.h,v 1.17 2002/06/22 13:03:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_APP_RES_H
#define GUIKACHU_APP_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Application;
    }
}

#include <iostream>
#include <string>

#include "property.h"
#include "queued-signal.h"

namespace Guikachu
{
    class ResourceManager; // Forward declaration
    
    namespace GUI
    {
	class AppWindow; // Forward declaration
    }
    
    namespace Resources
    {
	class Application: public SigC::Object
	{
	    ResourceManager *owner;
	    
	    GUI::AppWindow *gui;

	    class VendorID: public Property<std::string>
	    {
	    public:
		VendorID (notify_signal_t   &notify_signal,
			  const std::string &value);
		
		inline const std::string& operator= (const std::string &value_) { set_val (value_); return value; };
		virtual void set_val (const std::string &value);
	    };
	    
	public:
	    Application (ResourceManager *owner);
	    ~Application ();
	    QueuedSignal changed;

	    ResourceManager *get_manager () { return owner; };
	    
	    void show_ui ();

	    Property<std::string> iconname;
	    Property<std::string> version;
	    VendorID              vendor;
	    
	    void reset ();
	};
    };
};

#endif /* !GUIKACHU_APP_RES_H */
