//$Id: session.cc,v 1.11 2002/06/30 19:54:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "session.h"

#include "config.h"

#include <glade/glade.h>
#include <gnome--/client.h>
#include <libgnome/gnome-config.h>
#include <gconf/gconf.h>

#include "resource-manager.h"
#include "mainwin.h"
#include "preferences.h"

#include "io/guikachu-load.h"
#include "io/guikachu-save.h"

using namespace Guikachu;

Main* Guikachu::Main::instance_ = 0;

Main::Main (int argc, char **argv):
    Gnome::Main (PACKAGE, VERSION, argc, argv, NULL, 0, &ctx),
    cmd_self (argv[0])
{
    if (instance_)
    {
	g_warning("Guikachu::Main::Main called twice!\n");
	return;
    }

    instance_ = this;

    gconf_init (argc, argv, 0);
    glade_gnome_init ();
    
    // Set up session managment stuff
    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client)
    {
	session_client->die.connect (SigC::slot(this, &Main::session_die_cb));
	session_client->save_yourself.connect (SigC::slot(this, &Main::session_save_cb));
    }

    // Store command-line arguments
    const char **args = poptGetArgs (ctx);
    if (args)
	for (; *args; args++)
	    cmd_arguments.push_back (*args);
    poptFreeContext (ctx);

    // Load preferences
    Preferences::load ();

    // Create initial document
    doc = new ResourceManager;

    // Create main window
    mainwin = new GUI::MainWin;
    mainwin->set_manager (doc);
    mainwin->show ();
}


Main::~Main ()
{
    // Save preferences
    Preferences::save ();
}

void Main::new_doc ()
{
    delete doc;
    doc = new ResourceManager;
    
    mainwin->set_manager  (doc);
    mainwin->set_filename ("");
}

void Main::save_doc (const std::string &filename)
{
    IO::Saver *saver = new IO::GuikachuSaver;
    if (saver->save (doc, filename) == IO::RESULT_OK)
    {
	doc->clear_dirty ();
	set_filename (filename);
    }
}

void Main::load_doc (const std::string &filename)
{
    ResourceManager *new_doc = new ResourceManager;

    IO::Loader *loader = new IO::GuikachuLoader;
    if (loader->load (new_doc, filename) == IO::RESULT_OK)
    {
	delete doc;
	doc = new_doc;

	while (events_pending ())
	    iteration ();	
	doc->clear_dirty ();
	
	mainwin->set_manager  (doc);
	set_filename (filename);	
    }
}

void Guikachu::Main::session_die_cb ()
{
    quit ();
}

int Guikachu::Main::session_save_cb (int                phase,
				     GnomeSaveStyle     save_style,
				     gint               is_shutdown,
				     GnomeInteractStyle interact_style,
				     int                is_fast)
{
    save_open_file ();
    
    return TRUE;
}

void Guikachu::Main::save_open_file ()
{
    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client->is_connected ())
    {
	std::vector<std::string> argv;
	argv.push_back (cmd_self);
	argv.push_back (last_filename);
	
	session_client->set_clone_command (argv);
	session_client->set_restart_command (argv);
    }
}

void Guikachu::Main::set_filename (const std::string &filename)
{
    char *dirname = g_dirname (filename.c_str ());
    chdir (dirname);
    g_free (dirname);

    if (filename != "")
	Preferences::Interface::add_recent_file (filename);
    
    last_filename = filename;
    mainwin->set_filename (filename);
}
