//$Id: menu-res.cc,v 1.20 2002/06/14 21:37:52 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "menu-res.h"
#include "menu-win.h"

#include <gnome-xml/xmlmemory.h>

using namespace Guikachu;
using namespace Guikachu::Resources;

Menu::Menu (ResourceManager   *owner,
	    const std::string &id):
    Resource (owner, id),
    gui (0)
{
}

Menu::~Menu ()
{
    delete gui;
}

void Menu::show_ui ()
{
    if (!gui)
	gui = new GUI::MenuWindow (this);

    gui->show ();
}

bool Menu::register_menu (const std::vector<Resources::Menu::Submenu>& menu)
{
    bool success = true;
    
    for (std::vector<Resources::Menu::Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (std::vector<Resources::Menu::MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		if (!owner->register_id (j->id))
		    success = false;
	}
    }

    return success;
}

void Menu::deregister_menu (const std::vector<Resources::Menu::Submenu>& menu)
{
    for (std::vector<Resources::Menu::Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (std::vector<Resources::Menu::MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		owner->unregister_id (j->id);
	}
    }
}

void Menu::set_submenus (const std::vector<Menu::Submenu>& new_menu)
{
    std::vector<Submenu> old_submenus = submenus;
    
    deregister_menu (submenus);    
    if (!register_menu (new_menu))
    {
	deregister_menu (new_menu);
	register_menu (submenus);
    } else {
	submenus = new_menu;
    }

    changed ();
}
