//$Id: mainwin.h,v 1.14 2002/06/23 15:45:29 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_MAINWIN_H
#define GUIKACHU_MAINWIN_H

namespace Guikachu
{
    namespace GUI
    {
	class MainWin;
	class TreeItem;
    }
}

#include <gnome--/app.h>
#include <gtk--/tree.h>
#include <gtk--/fileselection.h>
#include <map>
#include "resource.h"
#include "resource-manager.h"

namespace Guikachu
{
    namespace GUI
    {
	class MainWin: public Gnome::App
	{
	    typedef std::map<Resources::Type, Gtk::TreeItem*>     subtree_map;
	    typedef std::map<Resource*, Guikachu::GUI::TreeItem*> treeitem_map;

	    ResourceManager *manager;
	    
	    Gtk::Tree     *top_tree;
	    Gtk::Tree     *main_tree;
	    Gtk::TreeItem *top_item;
	    subtree_map    subtrees;
	    treeitem_map   treeitems;

	    std::string filename;
	    bool        in_exit;

	    int recent_files_num;
	    
	public:
	    MainWin ();
	    void set_filename (const std::string& filename);
	    void set_manager  (ResourceManager *manager);
	    
	private:
	    void update_recent_files ();
	    
	    void create_tree_for_type (Resources::Type    type,
				       const std::string &category_name);

	    void update_title ();
	    void resource_created_cb (Resource *res);
	    void resource_removed_cb (Resource *res);

	    virtual int delete_event_impl (GdkEventAny *e);

	    void key_press_cb (GdkEventKey *e);
	    
	    void add_cb ();
	    void new_cb ();
	    void load_cb ();
	    void save_cb ();
	    void save_as_cb ();
	    void export_cb ();
	    void preferences_cb ();

	    void open (std::string filename);

	    void filesel_open_cb   (Gtk::FileSelection *fs);
	    void filesel_save_cb   (Gtk::FileSelection *fs);
	    void filesel_close_cb  (Gtk::FileSelection *fs);
	    void filesel_export_cb (Gtk::FileSelection *fs);

	    bool check_save ();
	};

	std::string visible_filename (const std::string &filename);
	
	void show_about ();
	void show_error   (const std::string &full_message,
			   const std::string &short_message = "");
	void show_warning (const std::string &full_message,
			   const std::string &short_message = "");
    }
}

#endif /* !GUIKACHU_MAINWIN_H */
