//$Id: widget.cc,v 1.20 2002/06/09 21:39:44 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget.h"

#include "resource-manager.h"

using namespace Guikachu;

Widget::Widget (Resources::Form   *owner_,
		const std::string &id_):
    owner (owner_),
    editor (0),
    id (changed, get_manager (), id_),
    x (changed, 0),
    y (changed, 0)
{
}

Widget::~Widget ()
{
#if 0
    // FIXME: This will need a real PropertyEditor abstract class
    if (editor)
	delete editor;
#endif
    
    for (canvas_item_map_t::iterator i = canvas_items.begin ();
	 i != canvas_items.end (); i++)
	delete i->second;
}

Gtk::Widget* Widget::get_editor ()
{
    if (!editor)
	editor = create_editor ();

    return editor;
}

ResourceManager* Widget::get_manager () const
{
    return owner->get_manager ();
}

Resources::Form* Widget::get_form () const
{
    return owner;
}

GUI::FormEditor::WidgetCanvasItem* Widget::get_canvas_item (Gnome::CanvasGroup *parent_group)
{
    GUI::FormEditor::WidgetCanvasItem *ret;
    
    canvas_item_map_t::iterator found = canvas_items.find (parent_group);
    if (found == canvas_items.end ())
	ret = canvas_items[parent_group] = create_canvas_item (parent_group);
    else
	ret = found->second;

    return ret;
}
