//$Id: scrollbar.h,v 1.15 2002/06/14 21:37:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_SCROLLBAR_H
#define GUIKACHU_FORM_EDITOR_SCROLLBAR_H

namespace Guikachu
{
    namespace Widgets
    {
	class ScrollBar;
    }
}

#include "widget.h"
#include "auto-resizeable.h"

#include "scrollbar-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class ScrollBar: public Widget,
			 public AutoWidth
	{
	    GUI::FormEditor::ScrollBarProperties *editor;

	public:
	    ScrollBar (Resources::Form   *owner,
		       const std::string &id);
	    virtual ~ScrollBar ();
	    
	    virtual Type get_type () const { return WIDGET_SCROLLBAR; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);

	    Property<bool> usable;
	    Property<int>  min_value, max_value, value, page_size;
	    
	protected:
	    int get_auto_width () const;

	private:
	    void update ();
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_SCROLLBAR_H */
