//$Id: popup-trigger.h,v 1.17 2002/06/14 21:37:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_POPUP_TRIGGER_H
#define GUIKACHU_FORM_EDITOR_POPUP_TRIGGER_H

namespace Guikachu
{
    namespace Widgets
    {
	class PopupTrigger;
    }
}

#include "widget.h"
#include "widget-ref.h"
#include "auto-resizeable.h"
#include "textual.h"

#include "popup-trigger-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class PopupTrigger: public Widget,
			    public AutoWidth,
			    public AutoHeight,
			    public Textual
	{
	    GUI::FormEditor::PopupTriggerProperties *editor;
	    
	public:
	    PopupTrigger (Resources::Form   *owner,
			  const std::string &id);
	    virtual ~PopupTrigger ();
	    
	    virtual Type get_type () const { return WIDGET_POPUP_TRIGGER; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);
	    
	    Properties::WidgetRef list_id;
	    Property<bool>        usable;
	    Property<bool>        anchor_right;

	protected:
	    int get_auto_width  () const;
	    int get_auto_height () const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_POPUP_TRIGGER_H */
