//$Id: pushbutton.cc,v 1.20 2002/03/15 17:47:09 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton.h"
#include "pushbutton-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::PushButton;
using namespace Guikachu::GUI::FormEditor;

PushButton::PushButton (Resources::Form   *owner,
			const std::string &id):
    Widget (owner, id),
    ResizeableWidget (changed),
    AutoWidth (changed),
    AutoHeight (changed),
    Textual (changed, id),
    
    editor (0),
    usable (changed, true),
    group (changed)
{
}

PushButton::~PushButton ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *PushButton::create_editor ()
{
    if (!editor)
	editor = new PushButtonProperties (this);
    
    return editor->get_editor ();
}

WidgetCanvasItem* PushButton::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new PushButtonCanvasItem (this, parent_group);
}


bool PushButton::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;

    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");

	    std::string width_str = curr_node.get_prop<std::string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }
	    
	    std::string height_str = curr_node.get_prop<std::string> ("height");
	    if (height_str == "auto")
	    {
		manual_height = false;
		height = 0;
	    } else {
		manual_height = true;
		height = atoi (height_str.c_str ());
	    }
	}
	else if (curr_node.name () == "text")
	{
	    text = curr_node.get_content ();
	    font = curr_node.get_prop<int> ("font");
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "group")
	    group = curr_node.get_prop<int> ("id");
	else
	    g_warning ("Error parsing `pushbutton' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void PushButton::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    if (manual_height)
	my_node.set_prop ("height", height);
    else
	my_node.set_prop ("height", "auto");
    
    /* Usable */
    if (usable)
	node.add_node ("usable");

    /* Label and font */
    my_node = node.add_node ("text", text);
    my_node.set_prop ("font", font);
    
    /* Group ID */
    node.add_node ("group").set_prop ("id", group);
}

void PushButton::save_rcp (std::ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("AUTO");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");

    ostr << "  PUSHBUTTON \"" << text << "\" ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";
    ostr << " FONT " << font;
    ostr << " GROUP " << group;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    
    ostr << std::endl;

    g_free (height_str);
    g_free (width_str);
}

int PushButton::get_auto_width () const
{
    int text_width = get_string_width (font, text);

    return text_width + 6;
}

int PushButton::get_auto_height () const
{
    return get_font_height (font);
}
