//$Id: property.cc,v 1.11 2002/05/12 13:07:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "property.h"
#include "resource-manager.h"

using namespace Guikachu;

ID::ID (notify_signal_t   &notify_signal,
	const std::string &value):
    Property<std::string> (notify_signal, value)
{
}

void ID::set_val (const std::string &value_)
{
    std::string real_id = ResourceManager::validate_id (value_);

    if (ResourceManager::rename_resource (value, real_id))
	Property<std::string>::set_val (real_id);
}

template<>
void Property<std::string>::set_val (const std::string &value_)
{
    if (value_ == value)
	return;
    
    std::string ascii_value = value_;
    
    for (std::string::iterator i = ascii_value.begin ();
	 i != ascii_value.end (); i++)
    {
	// Convert non-ASCII characters to _ placeholder
	if (*i < 0)
	    *i = '_';
    }
    
    value = ascii_value;
    changed ();
}

namespace Guikachu
{

template<>
std::ostream & operator<< (std::ostream &ostr, const Property<std::string> &prop)
{
    std::string escaped_string;
    const std::string &src = prop.value;

    for (std::string::const_iterator i = src.begin (); i != src.end (); i++)
    {
	if (*i == '\\')
	{
	    // Peek at next character
	    std::string::const_iterator next = i;
	    next++;
	    
	    if (next != src.end ())
	    {
		// Pass double backslashes through
		if (*next == '\\')
		{
		    escaped_string += "\\\\";
		    i++;
		    continue;
		}
		
		// Don't pass single backslashes from before quotes
		if (*next == '"')
		{
		    i++;
		    continue;
		}
		
	    } else {
		
		// This is a trailing single backslash so convert it
		// to double backslash
		escaped_string += "\\\\";
		break;
	    }
	} 
	
	if (*i == '"')
	{
	    escaped_string += "\\\"";
	    continue;
	}

	escaped_string += *i;
    }

    ostr << escaped_string;
    
    return ostr;
}
    
} // namespace Guikachu
