//$Id: list.h,v 1.13 2002/02/23 20:37:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_LIST_H
#define GUIKACHU_FORM_EDITOR_LIST_H

namespace Guikachu
{
    namespace Widgets
    {
	class List;
    }
}

#include "widget.h"
#include "auto-resizeable.h"

#include "list-prop.h"

#include <vector>

namespace Guikachu
{
    namespace Widgets
    {
	class List: public Widget,
		    public AutoWidth
	{
	    GUI::FormEditor::ListProperties *editor;

	    SigC::Signal0<void> manual_width_changed;
	    
	public:
	    List (Resources::Form   *owner,
		  const std::string &id);
	    virtual ~List ();
	    
	    virtual Type get_type () const { return WIDGET_LIST; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);

	    Property<int>                       font;
	    Property<int>                       visible_items;
	    Property<bool>                      usable;
	    Property<std::vector<std::string> > items;

	    int get_display_height () const;

	protected:
	    int get_auto_width () const;

	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_LIST_H */
