<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 ERDI Gergo <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="form/widgets/table/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:text> AUTO AUTO</xsl:text>
    <xsl:text>)</xsl:text>
  </xsl:template>

  <xsl:template match="form/widgets/table/table_data">

    <xsl:text> ROWS </xsl:text>
    <xsl:value-of select="@rows"/>

    <xsl:text> COLUMNS </xsl:text>
    <xsl:value-of select="count(column)"/>

    <xsl:text> COLUMNWIDTHS</xsl:text>
    <xsl:for-each select="column">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@width"/>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template match="form/widgets/table">

    <xsl:text>  TABLE</xsl:text>

    <xsl:text> ID </xsl:text>
    <xsl:value-of select="@id"/>

    <xsl:apply-templates select="pos"/>
    <xsl:apply-templates select="table_data"/>
    
    <xsl:text>
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
