//$Id: button.h,v 1.17 2002/01/26 00:19:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_BUTTON_H
#define GUIKACHU_FORM_EDITOR_BUTTON_H

namespace Guikachu
{
    namespace Widgets
    {
	class Button;

	enum ButtonFrameType
	{
	    BUTTON_FRAME_NONE,
	    BUTTON_FRAME_SIMPLE,
	    BUTTON_FRAME_BOLD
	};
    }
}

#include "widget.h"
#include "auto-resizeable.h"
#include "textual.h"

#include "button-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Button: public Widget,
		      public AutoWidth,
		      public AutoHeight,
		      public Textual
	{
	    GUI::FormEditor::ButtonProperties *editor;
	    
	public:
	    Button (Resources::Form   *owner,
		    const std::string &id);
	    virtual ~Button ();
	    
	    virtual Type get_type () const { return WIDGET_BUTTON; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);

	    Property<ButtonFrameType> frame;

	    Property<bool>            usable;
	    Property<bool>            repeat;
	    Property<bool>            anchor_right;

	protected:
	    virtual int get_auto_width  () const ;
	    virtual int get_auto_height () const;
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_BUTTON_H */
