<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 ERDI Gergo <cactus@cactus.rulez.org>

 utility.xsl (C) 2002 Christopher Keith Fairbairn, Gergo Erdi
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  
  <!-- Escape text for PilRC RCP Format -->
  <xsl:template name="escape-string-loop">
    <xsl:param name="text"/>
    
    <xsl:if test="$text != ''">
      <xsl:variable name="char" select="substring($text, 1, 1)"/>
      
      <xsl:choose>
	
	<xsl:when test="$char = '\'">
	  <xsl:variable name="next" select="substring($text, 2, 1)"/>	  
	  <xsl:choose>
	    
	    <xsl:when test="$next != ''">
	      
	      <xsl:choose>

		<!-- Pass double backslashes through -->
		<xsl:when test="$next = '\'">
		  <xsl:text>\\</xsl:text>
		  
		  <!-- index += 2 -->
		  <xsl:call-template name="escape-string-loop">
		    <xsl:with-param name="text" select="substring($text, 3)"/>
		  </xsl:call-template>		
		</xsl:when>

		<!-- Don't pass single backslashes from before quotes -->
		<xsl:when test="$next = '&quot;'">
		  <xsl:text>\"</xsl:text>
		  
		  <!-- index += 2 -->
		  <xsl:call-template name="escape-string-loop">
		    <xsl:with-param name="text" select="substring($text, 3)"/>
		  </xsl:call-template>
		</xsl:when>
		
		<xsl:otherwise>
		  <xsl:value-of select="$char"/>

		  <!-- index += 1 -->
		  <xsl:call-template name="escape-string-loop">
		    <xsl:with-param name="text" select="substring($text, 2)"/>
		  </xsl:call-template>		
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:when>

	    <xsl:otherwise>
	      <!-- Trailing single backslash -->
	      <xsl:text>\\</xsl:text>
	    </xsl:otherwise>
	    
	  </xsl:choose>
	</xsl:when>

	<xsl:otherwise>
	  <xsl:choose>
	    <xsl:when test="$char = '&quot;'">
	      <!-- Escape quotation marks -->
	      <xsl:text>\"</xsl:text>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="$char"/>
	    </xsl:otherwise>
	  </xsl:choose>
	  
	  <!-- index += 1 -->
	  <xsl:call-template name="escape-string-loop">
	    <xsl:with-param name="text" select="substring($text, 2)"/>
	  </xsl:call-template>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>


  
  <xsl:template match="text()|*/@*" mode="quote">
    <xsl:text>"</xsl:text>
    <xsl:call-template name="escape-string-loop">
         <xsl:with-param name="text" select="."/>
    </xsl:call-template>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <xsl:template match="text|title">
    <xsl:apply-templates select="text()" mode="quote"/>
  </xsl:template>
  
</xsl:stylesheet>
