<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 ERDI Gergo <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="form/widgets/list/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:if test="@width">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@width"/>
    </xsl:if>
    <xsl:text> AUTO</xsl:text>
    <xsl:text>)</xsl:text>  
  </xsl:template>
  
  <xsl:template match="form/widgets/list">

    <xsl:text>  LIST</xsl:text>

    <xsl:for-each select="items/item">
      <xsl:text> </xsl:text>
      <xsl:apply-templates mode="quote"/>
    </xsl:for-each>
 
    <xsl:text> ID </xsl:text>
    <xsl:value-of select="@id"/>

    <xsl:apply-templates select="pos"/>

    <xsl:text> FONT </xsl:text>
    <xsl:value-of select="items/@font"/>

    <xsl:choose>
      <xsl:when test="usable">
	<xsl:text> USABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> NONUSABLE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:text> VISIBLEITEMS </xsl:text>
    <xsl:value-of select="items/@visible"/>
    
    <xsl:text>
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
