//$Id: resource-ref.cc,v 1.6 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resource-ref.h"

using namespace Guikachu::Properties;
using std::string;

ResourceRef::ResourceRef (notify_signal_t &notify_signal,
			  const string    &value_):
    Property<string> (notify_signal, value_)
{
    current_resource = ResourceManager::get_resource (value);

    if (current_resource)
	current_resource_changed = current_resource->changed.connect (
	    SigC::slot (this, &ResourceRef::resource_changed_cb));

    ResourceManager::resource_created.connect (
	SigC::slot (this, &ResourceRef::resource_created_cb));
    ResourceManager::resource_removed.connect (
	SigC::slot (this, &ResourceRef::resource_removed_cb));
}

void ResourceRef::set_val (const string &value_)
{
    if (value_ == "")
	Property<string>::set_val ("");
    
    Resource *new_resource = ResourceManager::get_resource (value_);

    if (new_resource != current_resource)
    {
	current_resource_changed.disconnect ();
	current_resource = new_resource;

	if (current_resource)
	    current_resource_changed = current_resource->changed.connect (
		SigC::slot (this, &ResourceRef::resource_changed_cb));
    }

    Property<string>::set_val (value_);
}

void ResourceRef::resource_created_cb (Resource *res)
{
    if (res->id == value && !current_resource)
    {
	current_resource = res;
	current_resource_changed.disconnect ();
	current_resource_changed = current_resource->changed.connect (
	    SigC::slot (this, &ResourceRef::resource_changed_cb));
    }
}

void ResourceRef::resource_removed_cb (Resource *res)
{
    if (res == current_resource)
    {
	current_resource = 0;
	Property<string>::set_val ("");
    }
}

void ResourceRef::resource_changed_cb ()
{
    Property<string>::set_val (current_resource->id);
}
