//$Id: widget-canvas.cc,v 1.7 2002/02/05 21:34:24 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-canvas.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/main.h>
#include <gnome--/canvas-rect.h>
#include <gnome--/app-helper.h>
#include <libgnomeui/gnome-stock.h>

#include <list>
#include <algorithm>
#include <math.h>

#include <sigc++/retbind.h>

#include "form-editor.h"

using namespace Guikachu::GUI::FormEditor;

WidgetCanvasItem::WidgetCanvasItem (Widget             *widget_,
				    Gnome::CanvasGroup *parent_group_):
    CanvasItem (widget_, parent_group_),
    widget (widget_),
    selected (false),
    selection_box (0),
    dirty (false)
{
    // Chain signal callbacks
    canvas_item_changed.connect (SigC::slot (this, &WidgetCanvasItem::canvas_item_changed_cb));
    
    // Popup menu
    std::list <Gnome::UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	Gnome::UI::Item (Gnome::UI::Icon (GNOME_STOCK_MENU_PROP),
			 _("_Edit"), menu_edit.slot ()));
    popup_menu_list.push_back (
	Gnome::UI::Item (Gnome::UI::Icon (GNOME_STOCK_MENU_TRASH),
			 _("_Remove"), menu_remove.slot ()));
    
    Gnome::UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));
    
    widget->changed.connect  (SigC::slot (this, &WidgetCanvasItem::widget_changed_cb));
    widget->selected.connect (SigC::slot (this, &WidgetCanvasItem::widget_selected_cb));
}

WidgetCanvasItem::~WidgetCanvasItem ()
{
    if (selection_box)
	delete selection_box;
}

void WidgetCanvasItem::widget_changed_cb ()
{
    if (!dirty)
    {
	dirty = true;
	Gtk::Main::idle.connect (SigC::retbind (
	    SigC::slot (this, &WidgetCanvasItem::idle_cb), 0));
    }
}

void WidgetCanvasItem::idle_cb ()
{
    g_return_if_fail (dirty);

    update ();
    dirty = false;
}

void WidgetCanvasItem::canvas_item_changed_cb ()
{
    item->event.connect (SigC::retbind (
	SigC::slot (this, &WidgetCanvasItem::canvas_event_cb), 0));
    widget_selected_cb (selected);
}

void WidgetCanvasItem::canvas_event_cb (GdkEvent *e)
{
    // Context menu
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 3))
	popup_menu.popup (e->button.button, e->button.time);
}

Gnome::CanvasItem * WidgetCanvasItem::create_selection_box ()
{
    int x1, y1, x2, y2;
    
    get_bounds (x1, y1, x2, y2);
    x1 -= 2;
    x2 += 2;
    y1 -= 2;
    y2 += 2;

    using namespace Gnome::CanvasHelpers;
    Gnome::CanvasRect *bounding_box = new Gnome::CanvasRect (*overlay_group, x1, y1, x2, y2);
    *bounding_box
	<< width_units (2)
	<< outline_color (get_selection_color ());

    return bounding_box;
}

void WidgetCanvasItem::widget_selected_cb (bool selected_)
{
    selected = selected_;
    
    if (!selected)
    {
	if (selection_box)
	{
	    delete selection_box;
	    selection_box = 0;
	}
	return;
    }

    delete selection_box;
    selection_box = create_selection_box ();
    selection_box->lower_to_bottom ();
    
    parent_group->raise_to_top ();
}
