//$Id: session.cc,v 1.6 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "session.h"

#include "config.h"

#include <glade/glade.h>
#include <gnome--/client.h>
#include <libgnome/gnome-config.h>
#include <gconf/gconf.h>

#include "resource-manager.h"
#include "preferences.h"

Guikachu::Main* Guikachu::Main::instance_ = 0;

Guikachu::Main::Main (int argc, char **argv):
    Gnome::Main (PACKAGE, VERSION, argc, argv, NULL, 0, &ctx),
    cmd_self (argv[0])
{
    if (instance_)
    {
	g_warning("Guikachu::Main::Main called twice!\n");
	return;
    }

    instance_ = this;

    gconf_init (argc, argv, 0);
    glade_gnome_init ();
    
    Guikachu::ResourceManager::reset ();

    // Set up session managment stuff
    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client)
    {
	session_client->die.connect (SigC::slot(this, &Main::session_die_cb));
	session_client->save_yourself.connect (SigC::slot(this, &Main::session_save_cb));
    }

    // Store command-line arguments
    const char **args = poptGetArgs (ctx);
    if (args)
	for (; *args; args++)
	    cmd_arguments.push_back (*args);
    poptFreeContext (ctx);

    // Load preferences
    Preferences::load ();
}


Guikachu::Main::~Main ()
{
    // Save preferences
    Preferences::save ();
}

const std::vector<std::string>& Guikachu::Main::get_cmd_arguments ()
{
    return cmd_arguments;
}

void Guikachu::Main::session_die_cb ()
{
    quit ();
}

int Guikachu::Main::session_save_cb (int                phase,
				     GnomeSaveStyle     save_style,
				     gint               is_shutdown,
				     GnomeInteractStyle interact_style,
				     int                is_fast)
{
    save_open_file ();
    
    return TRUE;
}

void Guikachu::Main::save_open_file ()
{
    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client->is_connected ())
    {
	std::vector<std::string> argv;
	argv.push_back (cmd_self);
	argv.push_back (last_filename);
	
	session_client->set_clone_command (argv);
	session_client->set_restart_command (argv);
    }
}

void Guikachu::Main::set_filename (const std::string &filename)
{
    last_filename = filename;
}
